package com.infusiblecoder.myvideodownloaderv2;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import androidx.annotation.NonNull;
import androidx.multidex.MultiDex;
import androidx.multidex.MultiDexApplication;

import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;

public class App extends MultiDexApplication {
    private static App instance;

    public static boolean hasNetwork() {
        return instance.checkIfHasNetwork();
    }

    public static App getInstance() {
        return instance;
    }

    public void onCreate() {
        MultiDex.install(this);
        MobileAds.initialize(this, initializationStatus -> {

        });
        super.onCreate();
        instance = this;
    }

    public boolean checkIfHasNetwork() {
        NetworkInfo activeNetworkInfo = ((ConnectivityManager) getSystemService(CONNECTIVITY_SERVICE)).getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }


    public void attachBaseContext(Context context) {
        super.attachBaseContext(context);
        MultiDex.install(this);
    }
}
